//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/viewlib/vol_and_lr/RectangularVolumePropertySheet.h"
#include "GoTools/viewlib/vol_and_lr/ui_RectangularVolumePropertySheet_form.h"
#include "GoTools/viewlib/vol_and_lr/gvRectangularVolumePaintable.h"

#include "GoTools/trivariate/RectangularVolumeTesselator.h"

#include "GoTools/viewlib/gvData.h"
#include "GoTools/viewlib/gvObserver.h"

// #include <q3groupbox.h>
#include <QPushButton>
#include <QSlider>
#include <QCheckBox>

using namespace Ui;


//===========================================================================
RectangularVolumePropertySheet::~RectangularVolumePropertySheet()
//===========================================================================
{
   if (form_)
   {
      delete form_;
      form_=NULL;
   }
}

//===========================================================================
void RectangularVolumePropertySheet::createSheet(QWidget* parent, gvObserver* obs)
//===========================================================================
{
   if (form_)
   {
      delete form_;
      form_=NULL;
   }
   
    obs_ = obs;
    form_ = new Ui::RectangularVolumePropertySheet_form();//NULL);
    //insertChild(form_);

    QDialog* w = new QDialog();
    form_->setupUi(w);

    w->resize(form_->box->size());

    QObject::connect(form_->ApplyButton, SIGNAL(pressed()),
	    this, SLOT(apply()));
    connect(form_->CloseButton, SIGNAL(pressed()),
	    w, SLOT(close()));

//     std::cout << "I'm here!" << std::endl;

#if 0
    form_->VisibleCheck->setChecked(pable_->visible());
#endif

    int res;
    tess_->getRes(res);
    form_->ResSlider->setValue(res);

    w->show();
}



//===========================================================================
void RectangularVolumePropertySheet::apply()
//===========================================================================
{
    int res = form_->ResSlider->value();
#if 0
    int vres = form_->VresSlider->value();
    if (form_->TurnOrientationCheck->isChecked()) {
	surf_->turnOrientation();
	form_->TurnOrientationCheck->setChecked(false);
    }
    pable_->setVisible(form_->VisibleCheck->isChecked());
#endif
    tess_->changeRes(res);
    obs_->observedChanged();
}

