//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/viewlib/gvPainter.h"
#ifdef _MSC_VER
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <windows.h>
#endif
#ifdef __APPLE__
#include <OpenGL/gl.h>
#else
#include <GL/gl.h>
#endif


//===========================================================================
gvPainter::~gvPainter()
//===========================================================================
{
}

//===========================================================================
void gvPainter::drawScene(QGLWidget *w)
//===========================================================================
{
    ASSERT(paintables_.size() == textures_.size());
    for (size_t i = 0; i < paintables_.size(); ++i) {
	if (paintables_[i].get() == 0)
	    continue;
	glLoadName(paintables_[i]->id()); // A no-op when not in selection mode
	if (w!=NULL)
	  paintables_[i]->paintGL(w, textures_[i].get());
	else
	paintables_[i]->paint(textures_[i].get());
    }
}

