//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/viewlib/PointCloudPropertySheet.h"
#include "GoTools/viewlib/gvPointCloudPaintable.h"

#include "GoTools/viewlib/gvData.h"
#include "GoTools/viewlib/gvObserver.h"

#include "GoTools/viewlib/ui_PointCloudPropertySheet_form.h"

// #include <q3groupbox.h>
#include <QPushButton>
#include <QSlider>
#include <QCheckBox>
#include <QLCDNumber>

#include <cmath>

namespace {
    const double MAX_POINT_SIZE = 10.0;
}

using namespace Ui;

//===========================================================================
PointCloudPropertySheet::PointCloudPropertySheet(gvPointCloudPaintable* pable)
    : pable_(pable), form_(), obs_(0)
{}


//===========================================================================
void PointCloudPropertySheet::createSheet(QWidget* parent, gvObserver* obs)
//===========================================================================
{
    obs_ = obs;
    form_ = new Ui::PointCloudPropertySheet_form();//parent);

    QWidget* w = new QWidget();
    form_->setupUi(w);

    w->resize(form_->box->size());

    QObject::connect(form_->ApplyButton, SIGNAL(clicked()),
		     this, SLOT(apply()));
    QObject::connect(form_->CloseButton, SIGNAL(clicked()),
		     w, SLOT(close()));
// 		     form_, SLOT(close()));

    form_->VisibleCheck->setChecked(pable_->visible());
    form_->IdCheck->setChecked(pable_->getPaintId());
    double fraction = pable_->fractionRendered();
    int percentage = int(floor(fraction * 100.0) + 0.5);
    double ps = pable_->pointSize();
    int pspercent = int(ps/MAX_POINT_SIZE*100.0 + 0.5);
    form_->RenderSlider->setValue(percentage);
    form_->RenderLCDNumber->display(percentage);
    form_->PointsizeSlider->setValue(pspercent);
    form_->PointsizeLCDNumber->display(pspercent);

    w->show();
}



//===========================================================================
void PointCloudPropertySheet::apply()
//===========================================================================
{
    pable_->setVisible(form_->VisibleCheck->isChecked());
    pable_->setPaintId(form_->IdCheck->isChecked());
    int percentage = form_->RenderSlider->value();
    pable_->setFractionRendered(double(percentage)/100.0);
    double pointsize =
	double(form_->PointsizeSlider->value()) * MAX_POINT_SIZE / 100.0;
    pable_->setPointSize(pointsize);
    obs_->observedChanged();
}


