//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _RECTANGULARVOLUMEPROPERTYSHEET_H
#define _RECTANGULARVOLUMEPROPERTYSHEET_H



#include "GoTools/viewlib/vol_and_lr/ui_RectangularVolumePropertySheet_form.h"
#include "GoTools/viewlib/vol_and_lr/gvRectangularVolumePaintable.h"

#include "GoTools/viewlib/gvPropertySheet.h"
#include "GoTools/trivariate/ParamVolume.h"
#include "GoTools/trivariate/RectangularVolumeTesselator.h"

#include <QObject>

class gvData;
//class RectangularSurfaceTesselator;
class gvRectangularVolumePaintable;
// class RectangularSurfacePropertySheet_form;
//class ParamSurface;

/** Documentation ...
    etc
 */

class RectangularVolumePropertySheet : public QObject, public gvPropertySheet
{

Q_OBJECT

public:
    RectangularVolumePropertySheet(Go::RectangularVolumeTesselator* tess,
				   gvRectangularVolumePaintable* pable,
				   shared_ptr<Go::ParamVolume>& vol)
  : tess_(tess), pable_(pable), form_(), obs_(0), vol_(vol)
    {}

    virtual ~RectangularVolumePropertySheet();

    virtual void createSheet(QWidget* parent, gvObserver* obs);

public slots:
    void apply();
 

private:
    Go::RectangularVolumeTesselator* tess_;
    gvRectangularVolumePaintable* pable_;
    Ui::RectangularVolumePropertySheet_form* form_;
    gvObserver* obs_;
    shared_ptr<Go::ParamVolume> vol_;
};


#endif // _RECTANGULARVOLUMEPROPERTYSHEET_H

