//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _GVUTILITIES_H
#define _GVUTILITIES_H

/// Draw a cylinder, or possibly a cone.
void draw_cylinder(double x0, double y0, double z0,
                   double x1, double y1, double z1,
                   double radius, double radius2, int n);
/// Draw a set of axes.
void draw_gl_axes(int n, double r, double radius, double rim, double l);
void draw_gl_axes(double relscale);

typedef double FLOAT_TYPE;
typedef FLOAT_TYPE MATRIX3[9];
typedef FLOAT_TYPE MATRIX4[16];
FLOAT_TYPE m3_det( MATRIX3 mat );
void m3_identity( MATRIX3 mat );
void m3_inverse( MATRIX3 mr, MATRIX3 ma );
void m4_submat( MATRIX4 mr, MATRIX3 mb, int i, int j );
FLOAT_TYPE m4_det( MATRIX4 mr );
int m4_inverse( MATRIX4 mr, MATRIX4 ma );

#endif // _GVUTILITIES_H


