//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _GVPAINTABLE_H
#define _GVPAINTABLE_H


#include "GoTools/viewlib/gvColor.h"
class gvTexture;

class QGLWidget;

/** gvPaintable: Super class for OpenGL calls to geometric objects.
*/

class gvPaintable
{
public:
    /// The arguments of this constructor (which will be called
    /// only by subclasses) are the colors to use in normal and
    /// selected states.
    gvPaintable(const gvColor& ncolor,
		const gvColor& scolor,
		int id)
	: visible_(true), selected_(false),
	  normal_color_(ncolor),
	  selected_color_(scolor),
	  id_(id)
    {}
    /// If the selected-mode color is not specifyed, a lighter
    /// shade of the normal color will be used.
    gvPaintable(const gvColor& ncolor, int id)
	: visible_(true), selected_(false),
	  normal_color_(ncolor),
	  id_(id)
    {
	// Default behaviour:
	// Set the selected_color_ to a lighter shade of the
	// normal_color_.
	selected_color_.rgba[0] = 0.5f + 0.5f*normal_color_.rgba[0];
	selected_color_.rgba[1] = 0.5f + 0.5f*normal_color_.rgba[1];
	selected_color_.rgba[2] = 0.5f + 0.5f*normal_color_.rgba[2];
	selected_color_.rgba[3] = 0.5f + 0.5f*normal_color_.rgba[3];
    }
    virtual ~gvPaintable();

    /// The function that does the painting. Must be overridden
    /// by all subclasses. If your subclass does not use textures,
    /// just ignore the texture argument.
    virtual void paint(gvTexture* texture) = 0;

    virtual void paintGL(QGLWidget *w, gvTexture* texture)
    {
       paint(texture);
    }

    void setVisible(bool state)
    {
	visible_ = state;
    }
    bool visible() const
    {
	return visible_;
    }
    void setSelected(bool state)
    {
	selected_ = state;
    }
    bool selected() const
    {
	return selected_;
    }
    void setColor(const gvColor& ncolor,
		  const gvColor& scolor)
    {
	normal_color_ = ncolor;
	selected_color_ = scolor;
    }
    void setColor(const gvColor& ncolor)
    {
	normal_color_ = ncolor;
	// Set the selected_color_ to a lighter shade of the
	// normal_color_.
	selected_color_.rgba[0] = 0.5f + 0.5f*normal_color_.rgba[0];
	selected_color_.rgba[1] = 0.5f + 0.5f*normal_color_.rgba[1];
	selected_color_.rgba[2] = 0.5f + 0.5f*normal_color_.rgba[2];
	selected_color_.rgba[3] = 0.5f + 0.5f*normal_color_.rgba[3];
    }
    gvColor getNormalColor()
    {
	return normal_color_;
    }
    int id() const
    {
	return id_;
    }
    void setId(int id)
    {
	id_ = id;
    }

protected:
    bool visible_;
    bool selected_;
    gvColor normal_color_;
    gvColor selected_color_;
    int id_;
};



#endif // _GVPAINTABLE_H

