//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _GVOBJECTLIST_H
#define _GVOBJECTLIST_H

// Qt includes
#include <QWidget>
// #include <qbuttongroup.h>
#include <Q3ButtonGroup>
#include <QLayout>
#include <QPushButton>
//Added by qt3to4:
// #include <Q3VBoxLayout>
#include <QScrollArea>

class gvData;
#include "GoTools/viewlib/gvObserver.h"

/** Documentation ...
    etc
 */

class gvObjectList : public QWidget, public gvObserver
{

Q_OBJECT

public:
    gvObjectList(gvData& data,
		 QWidget* parent=0, const char* name=0, Qt::WFlags f=0);
    virtual ~gvObjectList();
    virtual void observedChanged();
    void buildGUI();

protected slots:
    void clicked(int id);

private:
    gvData& data_;
    int numobj_;
//     QButtonGroup* bg_;
    Q3ButtonGroup* bg_;
    QVBoxLayout* lay1_;
    QVBoxLayout* lay2_;

    QScrollArea* scroll_area_;

    void setCorrectButtonStates();
};


#endif // _GVOBJECTLIST_H

