//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _GVLINECLOUDPAINTABLE_H
#define _GVLINECLOUDPAINTABLE_H



#include "GoTools/viewlib/gvPaintable.h"
#include "GoTools/geometry/LineCloud.h"
#ifdef _MSC_VER
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <windows.h>
#endif
#ifdef __APPLE__
#include <OpenGL/gl.h>
#else
#include <GL/gl.h>
#endif
#include <cmath>

/** Documentation ...
    etc
 */

class gvLineCloudPaintable : public gvPaintable
{
public:
    gvLineCloudPaintable(const Go::LineCloud& lc,
			 const gvColor& ncolor,
			 const gvColor& scolor,
			 int id)
	: gvPaintable(ncolor, scolor, id),
	  lc_(lc), fractionrendered_(1.0)
    {}
    gvLineCloudPaintable(const Go::LineCloud& lc,
			  const gvColor& ncolor,
			  int id)
	: gvPaintable(ncolor, id),
	  lc_(lc), fractionrendered_(1.0)
    {}
    virtual ~gvLineCloudPaintable()
    {}

    virtual void paint(gvTexture*)
    {
	if (!visible_) return;
	glEnableClientState(GL_VERTEX_ARRAY);
	glDisable(GL_LIGHTING);
	if (selected_) {
	    glColor4fv(selected_color_.rgba);
	} else {
	    glColor4fv(normal_color_.rgba);
	}
	glVertexPointer(3, GL_DOUBLE, 0, lc_.point(0).begin());
	int numrendered = int(floor(lc_.numLines() * fractionrendered_) + 0.5);
	glDrawArrays(GL_LINES, 0, numrendered*2);
	glEnable(GL_LIGHTING);
	glDisableClientState(GL_VERTEX_ARRAY);
    }

    void setFractionRendered(double f)
    {
	fractionrendered_ = f;
    }

    double fractionRendered()
    {
	return fractionrendered_;
    }

protected:
    const Go::LineCloud& lc_;
    double fractionrendered_;
};






#endif // _GVLINECLOUDPAINTABLE_H

