//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _GVGROUPPROPERTYSHEET_H
#define _GVGROUPPROPERTYSHEET_H



#include "GoTools/viewlib/gvPropertySheet.h"
#include "GoTools/tesselator/RectangularSurfaceTesselator.h"
#include "GoTools/viewlib/ui_gvGroupPropertySheet_form.h"

#include <QObject>
// #include <q3table.h>
#include <QComboBox>
#include <vector>
#include <QLabel>

class gvData;
//class RectangularSurfaceTesselator;
class gvRectangularSurfacePaintable;
// class gvGroupPropertySheet_form;

/** Representation of several objects connected into one logical group.
 */

class gvGroupPropertySheet : public QObject, public gvPropertySheet
{

Q_OBJECT

public:
    gvGroupPropertySheet(std::vector<int>& members, QString& def_name);

    virtual void createSheet(QWidget* parent, gvObserver* obs);

    std::vector<int> getMembers();

public slots:
    void accept();

signals:
 void value_changed(std::vector<int>& members, QString name);


private:
    Ui::gvGroupPropertySheet_form* form_;
    std::vector<int> members_; // Save members according to position in relevant vector.
    QString def_name_;
    gvObserver* obs_;
};


#endif // _GVGROUPPROPERTYSHEET_H

