//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _GVGENERICTRIQUADPAINTABLE_H
#define _GVGENERICTRIQUADPAINTABLE_H


#include "GoTools/viewlib/gvPaintable.h"
#include "GoTools/viewlib/gvGenericTriMesh.h"
#include "GoTools/viewlib/gvGenericTriQuadMesh.h"
#ifdef _MSC_VER
#define NOMINMAX
#include <windows.h>
#endif
#include <GL/gl.h>

/** Documentation ...
    etc
 */

template <typename FloatType>
class gvGenericTriQuadPaintable : public gvPaintable
{
public:
    gvGenericTriQuadPaintable(gvGenericTriQuadMesh<FloatType>& mesh,
			  const gvColor& ncolor,
			  const gvColor& scolor,
			  int id)
	: gvPaintable(ncolor, scolor, id),
	  mesh_(mesh)
    {}
    gvGenericTriQuadPaintable(gvGenericTriQuadMesh<FloatType>& mesh,
			  const gvColor& ncolor,
			  int id)
	: gvPaintable(ncolor, id),
	  mesh_(mesh)
    {}
    virtual ~gvGenericTriQuadPaintable()
    {}

    virtual void paint()
    {
	GLenum fptype = GLfptype(FloatType());
	// Draw surfaces a little bit behind other things 
	glEnable (GL_POLYGON_OFFSET_FILL);
	glPolygonOffset (1.0, 1.0);

	// Deal with visibility and selection state
	if (!visible_) return;
	if (selected_) {
	    glMaterialfv(GL_FRONT_AND_BACK,
			 GL_AMBIENT_AND_DIFFUSE,
			 selected_color_.rgba);
	} else {
	    glMaterialfv(GL_FRONT_AND_BACK,
			 GL_AMBIENT_AND_DIFFUSE,
			 normal_color_.rgba);
	}
	GLfloat white[] = { 1.0, 1.0, 1.0, 1.0 };
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, white);
	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, 100.0);

    // Set up the vertex and normal arrays
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_NORMAL_ARRAY);
	glVertexPointer(3, fptype, 0, mesh_.vertexArray());
	//      std::cout << mesh_.vertexArray()[300] << ' '
	//  	      << mesh_.vertexArray()[301] << ' '
	//  	      << mesh_.vertexArray()[302] << std::endl;
	// @@@ We should check for the use of normals and textures in mesh_.
	glNormalPointer(fptype, 0, mesh_.normalArray());

    // Draw the triangles
	glDrawElements(GL_TRIANGLES, mesh_.numTriangles()*3,
		       GL_UNSIGNED_INT, mesh_.triangleIndexArray());
	glDrawElements(GL_QUADS, mesh_.numQuads()*3,
		       GL_UNSIGNED_INT, mesh_.quadIndexArray());

	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_NORMAL_ARRAY);
	glDisable(GL_POLYGON_OFFSET_FILL);
    }


protected:
    gvGenericTriQuadMesh<FloatType>& mesh_;
};





#endif // _GVGENERICTRIQUADPAINTABLE_H

