//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _SURFACERESOLUTIONSHEET_H
#define _SURFACERESOLUTIONSHEET_H


#include "GoTools/viewlib/gvPropertySheet.h"
#include "GoTools/tesselator/RectangularSurfaceTesselator.h"
#include "GoTools/viewlib/ui_SurfaceResolutionSheet_form.h"

#include <QObject>

class gvData;
//class RectangularSurfaceTesselator;
class gvRectangularSurfacePaintable;

/** Documentation ...
    etc
 */

class SurfaceResolutionSheet : public QObject, public gvPropertySheet
{

Q_OBJECT

public:
SurfaceResolutionSheet(int ures = 20, int vres = 20) // The default res is 20x20.
     : form_(0), ures_(ures), vres_(vres), def_high_res_(200) //, obs_(0)
    {}
    virtual void createSheet(QWidget* parent, gvObserver* obs);

public slots:
    void ok();

signals:
    void return_value(int, int); // Return new resolution.


private:
    Ui::SurfaceResolutionSheet_form* form_;
    int ures_;
    int vres_;
    int def_high_res_; // Used in setHighRes().
/*     gvObserver* obs_; */

private slots:

    // Set default high resolution (optimized mode an advantage).
    // Accessed through button.
    void setHighRes();

};


#endif // _SPLINESURFACEPROPERTYSHEET_H

