//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _DATAHANDLER_H
#define _DATAHANDLER_H


#include "GoTools/viewlib/gvColor.h"
#include "GoTools/tesselator/Tesselator.h"

#include "GoTools/utils/config.h"


//class Tesselator;
class gvPaintable;
class gvPropertySheet;
namespace Go
{
    class GeomObject;
}

/** This class connects the four inheritance trees descending
 * from gvTesselator, gvPaintable, gvPropertySheet and GeomObject.
 */

class DataHandler
{
public:
    /// Default constructor.
    /// In inherited classes, it should Initialize factory
    /// (by registering classes).
    DataHandler();
    virtual ~DataHandler();

    virtual void create(shared_ptr<Go::GeomObject> obj,
			const gvColor& col, int id) = 0;

    shared_ptr<Go::Tesselator> tesselator()
    {
	return tesselator_;
    }
    shared_ptr<gvPaintable> paintable()
    {
	return paintable_;
    }
    shared_ptr<gvPropertySheet> propertySheet()
    {
	return property_sheet_;
    }

    void clear()
    {
        tesselator_.reset();
	paintable_.reset();
	property_sheet_.reset();
    }

protected:
    shared_ptr<Go::Tesselator> tesselator_;
    shared_ptr<gvPaintable> paintable_;
    shared_ptr<gvPropertySheet> property_sheet_;
};


#endif // _DATAHANDLER_H

