//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include <utility>
#include <QApplication>

#include "GoTools/viewlib/DefaultDataHandler.h"
#include "GoTools/viewlib/gvApplication.h"


/** An application for viewing spline surfaces and other geometrical objects.
 *
 *  The program is based on the QT toolkit, OpenGL and Sintef's Go toolkit.
 *  
 */

int less_largest_x_cntr=0, less_largest_y_cntr=0, less_smallest_y_cntr=0;

int main(int argc, char** argv)
{
//     // Use the generic app object
    QApplication theapp(argc, argv);

    // Create our main widget
    std::auto_ptr<DataHandler> dh(new DefaultDataHandler);
    gvApplication* appwidget = new gvApplication(dh, NULL, argv[0]);

    appwidget->resize(500, 530);
//    appwidget->resize(1300, 1100);
    appwidget->show();
//     theapp.setMainWidget(appwidget);
    theapp.setActiveWindow(appwidget);

    int return_value=theapp.exec();
    return return_value;
}

