//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _FTVOLUMETOOLS_H
#define _FTVOLUMETOOLS_H

#include <vector>
#include <memory>
#include "GoTools/utils/config.h"

namespace Go
{
  class ftVolume;
  class ftSurface;
  class ftEdge;
  class SurfaceModel;

  /// This namespace contains a function for splitting of volumes
  namespace ftVolumeTools
  {
    /// Split two volumes with regard to the intersections between 
    /// the boundary surfaces corresponding to these two volumes
    std::vector<shared_ptr<ftVolume> >
      splitVolumes(shared_ptr<ftVolume>& vol1, 
		   shared_ptr<ftVolume>& vol2, double eps);

    /// Split one volume according to intersections with a given face
    std::vector<shared_ptr<ftVolume> >
      splitVolumes(shared_ptr<ftVolume>& vol, 
		   shared_ptr<ftSurface>& face, double eps);

    /// Specific functionality. Used from ftVolume::generateMissingBdSurf
    void updateWithSplitFaces(shared_ptr<SurfaceModel> shell,
			      shared_ptr<ftSurface>& face1,
			      shared_ptr<ftSurface>& face2,
			      std::vector<std::pair<ftEdge*, ftEdge*> >& replaced_wires);

 
  }  // namespace ftVolumeTools
} // namespace Go

#endif // _FTVOLUMETOOLS_H
