//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/trivariate/SurfaceOnVolumeTools.h"
#include "GoTools/geometry/CurveOnSurface.h"
#include "GoTools/geometry/SurfaceTools.h"

namespace Go {

//===========================================================================
  CurveLoop 
  SurfaceOnVolumeTools::getOuterBoundaryLoop(shared_ptr<SurfaceOnVolume> sf,
					     double eps)
//===========================================================================
  {
    CurveLoop spacecrvs = SurfaceTools::outerBoundarySfLoop(sf->spaceSurface(), eps);

    int nmb = spacecrvs.size();
    for (int ki=0; ki<nmb; ++ki)
      {
	shared_ptr<ParamCurve> cv = spacecrvs[ki];
	shared_ptr<CurveOnSurface> sfcrv = 
	  dynamic_pointer_cast<CurveOnSurface, ParamCurve>(cv);
	if (sfcrv.get())
	  {
	    sfcrv->setUnderlyingSurface(sf);
	    sfcrv->ensureParCrvExistence(eps);
	  }
      }
    return spacecrvs;
  }
}
