//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef __VOLUMEINTERPOLATOR_H
#define __VOLUMEINTERPOLATOR_H

#include "GoTools/geometry/BsplineBasis.h"
#include "GoTools/utils/Point.h"

namespace Go
{
  class SplineVolume;

/// This namespace contains functions used to interpolate a set of points
  namespace VolumeInterpolator
  {
    /// Interpolate a set of regular, parameterized interpolation
    /// points. The parameterization is assumed to correspond to the
    /// given B-spline basises (select interpolation points in the
    /// Greville points). The function throws if the input parameters
    /// are inconsistent
    /// \param basis_u spline basis in the first parameter direction
    /// \param basis_v spline basis in the second parameter direction
    /// \param basis_w spline basis in the third parameter direction
    /// \param par_u parameter values in 1. parameter direction corresponding
    /// to point
    /// \param par_v parameter values in 2. parameter direction corresponding
    /// to point
    /// \param par_w parameter values in 2. parameter direction corresponding
    /// to point
    /// \param points the regular point set
    /// \param dimension dimension of geometry space
    /// \param rational whether or not a rational surface is expected
    /// \param weights the weights of the rational volume, used only if 
    /// rational==true
    SplineVolume* regularInterpolation(const BsplineBasis& basis_u,
				       const BsplineBasis& basis_v,
				       const BsplineBasis& basis_w,
				       std::vector<double>& par_u,
				       std::vector<double>& par_v,
				       std::vector<double>& par_w,
				       std::vector<double>& points,
				       int dimension,
				       bool rational,
				       std::vector<double>& weights);

  };    // namespace VolumeInterpolator


} // namespace Go


#endif    // #ifndef __VOLUMEINTPEROLATOR_H

