//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _GAPREMOVALVOLUME_H
#define _GAPREMOVALVOLUME_H


#include "GoTools/trivariate/SplineVolume.h"
#include "GoTools/trivariate/SurfaceOnVolume.h"



namespace Go {

  /// Removal of gaps between two adjacent volumes
  /// No implementation

namespace GapRemoval
{

  /// We average the volumes along the matching faces on the
  /// rectangular domain given by vertex lower left and upper right
  /// (assuming that such a domain is well defined).
  void
  removeGapSpline(shared_ptr<SplineVolume>& vol1, 
		  shared_ptr<SurfaceOnVolume>& bd_sf1,
		  double sf1_start1, double sf1_end1,
		  double sf1_start2, double sf1_end2,
		  shared_ptr<SplineVolume>& vol2, 
		  shared_ptr<SurfaceOnVolume>& bd_sf2,
		  double sf2_start1, double sf2_end1,
		  double sf2_start2, double sf2_end2,
		  Point vertex_ll, Point vertex_ur,
		  double epsge, int orientation);

}
}

#endif // _GAPREMOVALVOLUME_H

