//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef __ELEMENTARYVOLUME_H
#define __ELEMENTARYVOLUME_H


#include "GoTools/trivariate/ParamVolume.h"


namespace Go
{

  class SplineVolume;


  /// \brief ElementaryVolume is a base class for elementary volumes
  /// like boxes and solid cylinders. Such volumes have natural
  /// parametrizations and ElementartVolume is therefore a subclass of
  /// ParamVolume. These volumes are non-self-intersecting.

  class ElementaryVolume : public ParamVolume
  {

  public:

    /// Virtual destructor, enables safe inheritance.
    virtual ~ElementaryVolume() { }

    // --- Functions inherited from GeomObject ---
    virtual ElementaryVolume* clone() const = 0;


    /// Make a NURBS representation of the object
    virtual SplineVolume* geometryVolume() const = 0;

  };    // Class ElementaryVolume


} // namespace Go



#endif    // #ifndef __ELEMENTARYVOLUME_H
