//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _TPTOLERANCES_H_
#define  _TPTOLERANCES_H_

namespace Go
{

/** tpTolerances -  Tolerances used in adjacency analysis for faces
 */
struct tpTolerances
{
public:
  /// Tolerance for when two faces are assumed to be C0 continous
    double gap;
  /// Tolerance for when two faces are assumed to be neighbours
    double neighbour;
  /// Tolerance for when two adjacent faces are assumed to be C1 continous
    double kink;
  /// Tolerance for when two adjacent faces are assumed to have an 
  /// intentially smooth connection
    double bend;
    tpTolerances(double g, double n, double k, double b)
	: gap(g), neighbour(n), kink(k), bend(b)
    {}
    tpTolerances(const tpTolerances& tol)
	: gap(tol.gap), neighbour(tol.neighbour), kink(tol.kink),
          bend(tol.bend)
    {}
};

} // namespace Go

#endif //  _TPTOLERANCES_H_
