//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef __CMUTILS_H
#define __CMUTILS_H


#include "GoTools/geometry/ParamSurface.h"
#include "GoTools/geometry/SplineSurface.h"
#include "GoTools/geometry/BoundedSurface.h"
#include "GoTools/geometry/CurveLoop.h"


namespace Go
{

namespace qualityUtils
{

  // Determine whether a surface is a sliver face or not
  // Uses different method for SplineSurface and BoundedSurface
  // A surface is a sliver suface if its maximum length m1 in one
  // parameter direction is less than a thickness given as a parameter,
  // while its minimum length in the other parameter direction is
  // more than m1 * a factor, typically 2.0
  bool isSliverFace(shared_ptr<ParamSurface>,
		    double thickness,
		    double factor = 2.0);

  bool isSliverFace(const SplineSurface& sf,
		    double thickness,
		    double factor = 2.0);

  bool isSliverFace(const BoundedSurface& sf,
		    double thickness,
		    double factor = 2.0);

  bool isSliverFace2(const BoundedSurface& sf,
		     double thickness,
		     double factor = 2.0);

  bool hasIndistinctKnots(shared_ptr<ParamSurface> surf, double tol,
			  std::vector<shared_ptr<ParamCurve> >& trim_cv_knots);

  double estimateArea(shared_ptr<ParamSurface> surf);

  double estimateLoopArea(shared_ptr<CurveLoop> loop);

}   // namespace qualityUtils

}   // namespace Go


#endif    // #ifndef __CMUTILS_H
