//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/compositemodel/SurfaceModel.h"
#include "GoTools/compositemodel/CompositeModelFactory.h"
#include "GoTools/qualitymodule/FaceSetQuality.h"
#include <fstream>

using std::vector;
using std::pair;
using namespace Go;

int main( int argc, char* argv[] )
{
  // Read input arguments
  std::ifstream file1("data/DemEx6.g2");
  ALWAYS_ERROR_IF(file1.bad(), "Input file not found or file corrupt");

  double gap = 0.001;
  double neighbour = 0.002;
  double kink = 0.01;
  double approxtol = 0.01;

  CompositeModelFactory factory(approxtol, gap, neighbour, kink, 10.0*kink);
  //CompositeModelFactory factory(approxtol, gap, neighbour, kink, 100.0*kink);

  shared_ptr<CompositeModel> model = shared_ptr<CompositeModel>(factory.createFromG2(file1));
  shared_ptr<SurfaceModel> sfmodel = dynamic_pointer_cast<SurfaceModel,CompositeModel>(model);

  FaceSetQuality quality(gap, kink, approxtol);
  quality.attach(sfmodel);

  vector<pair<ftEdge*, ftEdge*> > gaps;
  vector<pair<ftEdge*, ftEdge*> > kinks;
  quality.edgePosAndTangDiscontinuity(gaps, kinks);  

  std::cout << "Number of gaps: " << gaps.size() << std::endl;
  std::cout << "Number of kinks: " << kinks.size() << std::endl;

  std::ofstream out_file("edge_gaps.g2");
  size_t ki;
  for (ki=0; ki<gaps.size(); ++ki)
  {
      shared_ptr<ParamCurve> crv1 = gaps[ki].first->geomCurve();
      shared_ptr<CurveOnSurface> sfcv = 
	dynamic_pointer_cast<CurveOnSurface,ParamCurve>(crv1);
      if (sfcv.get())
	{
	  sfcv->spaceCurve()->writeStandardHeader(out_file);
	  sfcv->spaceCurve()->write(out_file);
	}
      else
	{
	  crv1->writeStandardHeader(out_file);
	  crv1->write(out_file);
	}

      crv1 = gaps[ki].second->geomCurve();
      sfcv = dynamic_pointer_cast<CurveOnSurface,ParamCurve>(crv1);
      if (sfcv.get())
	{
	  sfcv->spaceCurve()->writeStandardHeader(out_file);
	  sfcv->spaceCurve()->write(out_file);
	}
      else
	{
	  crv1->writeStandardHeader(out_file);
	  crv1->write(out_file);
	}
  }

  std::ofstream out_file2("edge_kinks.g2");
  for (ki=0; ki<kinks.size(); ++ki)
  {
      shared_ptr<ParamCurve> crv1 = kinks[ki].first->geomCurve();
      shared_ptr<CurveOnSurface> sfcv = 
	dynamic_pointer_cast<CurveOnSurface,ParamCurve>(crv1);
      if (sfcv.get())
	{
	  sfcv->spaceCurve()->writeStandardHeader(out_file2);
	  sfcv->spaceCurve()->write(out_file2);
	}
      else
	{
	  crv1->writeStandardHeader(out_file2);
	  crv1->write(out_file2);
	}

      crv1 = kinks[ki].second->geomCurve();
      sfcv = dynamic_pointer_cast<CurveOnSurface,ParamCurve>(crv1);
      if (sfcv.get())
	{
	  sfcv->spaceCurve()->writeStandardHeader(out_file2);
	  sfcv->spaceCurve()->write(out_file2);
	}
      else
	{
	  crv1->writeStandardHeader(out_file2);
	  crv1->write(out_file2);
	}
  }
}

