//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include <math.h>
#include <stdlib.h>
#include "GoTools/parametrization/PrWaveletUtil.h"

//-----------------------------------------------------------------------------
double theta(int j, int k, int i, int deg, bool isBoundary)
//-----------------------------------------------------------------------------
// Given a coarse vertex v of degree deg whose index is i
// and two neighbouring fine vertices u1 and u2 which are the (j+1)-th and
// (k+1)-th neighbours resp., in an anticlockwise direction,
// (i.e. j and k begin theie numbering at 0)
// (which may possibly be equal), return the function
// theta(u1,u2,v), described in a paper by Floater and Quak.
{
  double lambda = 0.5 * (sqrt(21.0) - 5.0);
  if(isBoundary)
  {
    int a1 = (j <= k ? j : k);             // a1 = min(j,k)
    int a2 = deg - (j >= k ? j : k) - 1;   // a2 = deg - max(j,k) - 1
    return   ( pow(lambda,(double)a1) + pow(lambda,(double)(-a1)) )
           * ( pow(lambda,(double)a2) + pow(lambda,(double)(-a2)) )
           / ( pow(lambda,(double)(-deg+1)) - pow(lambda,(double)(deg-1)) )
           / sqrt(21.0);
  }
  else
  {
    int a = abs(k-j);
    return ( pow(lambda,(double)a) + pow(lambda,(double)(deg - a)) )
           / ( 1.0 - pow(lambda,(double)(deg)) )
           / sqrt(21.0);
  }
}

