//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/parametrization/PrPrmUniform.h"

// PRIVATE METHODS

//-----------------------------------------------------------------------------
bool
PrPrmUniform::makeWeights(int)
//-----------------------------------------------------------------------------
//  Calculate uniform weights for the
//  interior node i of the graph
//  It is assumed here that the indices of the neighbours of i
//  have already been stored in neighbours_.
//  This is the first parametrization in the article:
//  M. S. Floater, "Parametrization and smooth approximation of
//  surface triangulations", CAGD 14 (1997), 231--250.
{
  weights_.clear();
  int n = (int)neighbours_.size();
  double oneOverDegree = 1.0 / (double)n;
  for(int j=1; j<=n; j++) weights_.push_back(oneOverDegree);
  return true;
}

// PUBLIC METHODS

//-----------------------------------------------------------------------------
PrPrmUniform::PrPrmUniform()
: PrParametrizeInt()
//-----------------------------------------------------------------------------
{
}

//-----------------------------------------------------------------------------
PrPrmUniform::~PrPrmUniform()
//-----------------------------------------------------------------------------
{
}

