//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/parametrization/PrPrmLeastSquare.h"

// PRIVATE METHODS

//-----------------------------------------------------------------------------
bool
PrPrmLeastSquare::makeWeights(int i)
//-----------------------------------------------------------------------------
//  Calculate weights according to a weighted least squares method
//  for the interior node i of the graph.
//  Here we weight by the reciprocal of edge length.
//  It is assumed here that the indices of the neighbours of i
//  have already been stored in neighbours_.
//  This is the second parametrization in the article:
//  M. S. Floater, "Parametrization and smooth approximation of
//  surface triangulations", to appear in CAGD, 1997.
{
  weights_.clear();
  int n = (int)neighbours_.size();

  double weight_sum = 0.0, weight;

  int j;
  for (j=0; j<n; j++)
  {
    int j1 = neighbours_[j];
    weight = (g_->get3dNode(i)).dist(g_->get3dNode(j1));
    if(weight == 0.0) weight = 1.0;
    else weight = 1.0 / weight;
    weights_.push_back(weight);
    weight_sum += weight;
  }

  // Scale the weights so that they sum to 1.
  for(j=0; j<n; j++) weights_[j] /= weight_sum;

  return 1;
}

// PUBLIC METHODS

//-----------------------------------------------------------------------------
PrPrmLeastSquare::PrPrmLeastSquare()
: PrParametrizeInt()
//-----------------------------------------------------------------------------
{
}

//-----------------------------------------------------------------------------
PrPrmLeastSquare::~PrPrmLeastSquare()
//-----------------------------------------------------------------------------
{
}


