//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/parametrization/PrNestedTriangulation.h"

//----------------------------------------------------------------------------
void PrNestedTriangulation::getParents(int i, int jlev, int& p1, int& p2)
//-----------------------------------------------------------------------------
// Assuming that node i belongs to V^j\V^{j-1} and that
// jlev >= 1, find i's two parent nodes in V^{j-1} p1 and p2.
{
  vector<int> neighbours;
  getNeighbours(i,jlev,neighbours);
  if(isBoundary(i))
  {
    // Then there are exactly four neighbours. We want the
    // first and last ones.
    p1 = neighbours[0];
    p2 = neighbours[3];
    return;
  }
  else
  {
    // Then there are exactly six neighbours. Find the first
    // coarse one.
    if(neighbours[0] < getNumNodes(jlev-1))
    {
      p1 = neighbours[0];
      p2 = neighbours[3];
      return;
    }
    else if(neighbours[1] < getNumNodes(jlev-1))
    {
      p1 = neighbours[1];
      p2 = neighbours[4];
      return;
    }
    else
    {
      p1 = neighbours[2];
      p2 = neighbours[5];
      return;
    }
  }
}

