//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/parametrization/PrFilterbank.h"


//-----------------------------------------------------------------------------
PrFilterbank::~PrFilterbank()
//-----------------------------------------------------------------------------
{
}

//-----------------------------------------------------------------------------
void PrFilterbank::attach(shared_ptr<PrNestedTriangulation> t)
//-----------------------------------------------------------------------------
{
  t_ = t;
}

//-----------------------------------------------------------------------------
void PrFilterbank::decomposeAll(int dim)
//-----------------------------------------------------------------------------
{
  for(int j = t_->getFinestLevel(); j >= 1; j--) decompose(j,dim);
}

//-----------------------------------------------------------------------------
void PrFilterbank::decomposeFrom(int jlev, int dim)
//-----------------------------------------------------------------------------
{
  for(int j = jlev; j >= 1; j--) decompose(j,dim);
}

//-----------------------------------------------------------------------------
void PrFilterbank::composeAll(int dim)
//-----------------------------------------------------------------------------
{
  for(int j = 1; j <= t_->getFinestLevel(); j++) compose(j,dim);
}

//-----------------------------------------------------------------------------
void PrFilterbank::composeUpTo(int jlev, int dim)
//-----------------------------------------------------------------------------
{
  for(int j = 1; j <= jlev; j++) compose(j,dim);
}
