//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef PRVEC_H
#define PRVEC_H

#include <vector>
#include <iostream>

/*<PrVec-syntax: */

/** PrVec -  This class represents a vector.
 *
 */
class PrVec
{
protected:

    std::vector<double> a_;

public:
    /// Default constructor
    PrVec()
    {}
    /// Constructor. Constructs a vector with n elements initialized
    /// by fill_with.
    PrVec(int n, double fill_with = 0.0)
	: a_(n, fill_with)
    {}

    /// Constructor generating av vector from a range of elements 
    /// specified with two iterators.
    template <typename InputIterator>
    PrVec(InputIterator begin, InputIterator end)
	: a_(begin, end)
    {}

    /// Change size of vector
    void redim(int n, double fill_with = 0.0);

    /// Query size of vector
    int size() const {return (int)a_.size();}

    /// Element access
          double& operator () (int i) {return a_[i];}
    /// Element access
    const double& operator () (int i) const {return a_[i];}
    /// Element access
          double& operator [] (int i) {return a_[i];}
    /// Element access
    const double& operator [] (int i) const {return a_[i];}

    /// Compute inner product with another vector of the same length.
    double inner(const PrVec& x);

    /// Read vector elements from stream 'is'.
    void read(std::istream& is);

    /// Write vector elements, separated with spaces, to stream 'os'
    void print(std::ostream& os);
};


/*>PrVec-syntax: */

/*Class:PrVec

Name:              PrVec
Syntax:	           @PrVec-syntax
Keywords:
Description:       
Member functions:
                   
Constructors:
Files:
Example:

See also:
Developed by:      SINTEF Applied Mathematics, Oslo, Norway
Author:	           Michael Floater, SINTEF
Date:              Dec. 98
*/

#endif // PRVEC_H





