//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef PRPRMSURFACE_H
#define PRPRMSURFACE_H

#include "GoTools/parametrization/PrParametrizeInt.h"

/*<PrPrmSurface-syntax: */

/** PrPrmSurface - Implement the shape-preserving parametrization
 * by implementing the virtual function makeWeights  
 */
class PrPrmSurface : public PrParametrizeInt
{
private:
  std::vector<double> u_;
  std::vector<double> v_;
  std::vector<double> alpha_;
  std::vector<double> len_;

  std::vector<double> uold_;
  std::vector<double> vold_;
  std::vector<double> weightsold_;

  virtual
  bool       makeWeights(int i);
  bool       makeWeights(std::vector<double>& u,
			 std::vector<double>& v,
			 std::vector<double>& weights);
  bool       localParamXYZ(int i);
  bool       localParamUV(int i);

public:
  /// Default constructor
  PrPrmSurface();
  /// Empty destructor
  virtual ~PrPrmSurface();

};


/*>PrPrmSurface-syntax: */

/*Class:PrPrmSurface

Name:              PrPrmSurface
Syntax:	           @PrPrmSurface-syntax
Keywords:
Description:       Implement the shape-preserving parametrization
                   by implementing the virtual function makeWeights.
Member functions:
                   "attach(PrOrganizedPoints& graph)" --\\
                   Set the planar graph.

Constructors:
Files:
Example:
See also:
Developed by:      SINTEF Applied Mathematics, Oslo, Norway
Author:	           Michael Floater, SINTEF
Date:              Nov. 98
*/

#endif // PRPRMSURFACE_H
