//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef PRPRMMEANVALUE_H
#define PRPRMMEANVALUE_H

#include "GoTools/parametrization/PrParametrizeInt.h"

/*<PrPrmMeanValue-syntax: */

/** PrPrmMeanValue -  Implement the mean value parametrization
 * by implementing the virtual function makeWeights.
 * See preprint "Mean Value Coordinates", M.S. Floater.
 * This method is now THE recommended method.
 * The mapped points of the mean value parameterization
 * depend infinitely smoothly on the original data points,
 * unlike the shape-preserving parameterization.
 * However, in many examples that have been tested,
 * the two methods give similar results.
 * (MF. August 2002).
 */
class PrPrmMeanValue : public PrParametrizeInt
{
protected:

  virtual bool makeWeights(int i);

public:
  /// Default constructor
  PrPrmMeanValue();
  /// Empty destructor
  virtual ~PrPrmMeanValue();

};


/*>PrPrmMeanValue-syntax: */

/*Class:PrPrmMeanValue

Name:              PrPrmMeanValue
Syntax:	           @PrPrmMeanValue-syntax
Keywords:
Description:       Implement the mean value parametrization
                   by implementing the virtual function makeWeights.
                   See preprint "Mean Value Coordinates", M.S. Floater.
                   This method is now THE recommended method.
                   The mapped points of the mean value parameterization
                   depend infinitely smoothly on the original data points,
                   unlike the shape-preserving parameterization.
                   However, in many examples that have been tested,
                   the two methods give similar results.
                   (MF. August 2002).
Member functions:
                   "attach(PrOrganizedPoints& graph)" --\\
                   Set the planar graph.

Constructors:
Files:
Example:
See also:
Developed by:      SINTEF Applied Mathematics, Oslo, Norway
Author:	           Michael Floater, SINTEF
Date:              Apr. 2002
*/

#endif // PRPRMMEANVALUE_H
