//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef PRMATRIX_H
#define PRMATRIX_H


#include "GoTools/parametrization/PrVec.h"

/*<PrMatrix-syntax: */

/// This class implements a matrix
class PrMatrix
{

public:
  // pure virtual functions...
  /// Number of rows
  virtual int rows() const  = 0;
  /// Number of columns
  virtual int colmns() const = 0;
  /// value of matrix element
  virtual double operator () (int i, int j) const = 0;
  /// Multiply matrix with 'x' and return result in 'y'.  (y = Ax)
  virtual void prod(const PrVec& x, PrVec& y) const = 0;
  /// Virtual destructor
  virtual ~PrMatrix();

  /// print contents to stream
  virtual void print(std::ostream& os);
  /// read contents from stream
  virtual void read(std::istream& is) = 0;
};

/*>PrMatrix-syntax: */

/*Class:PrMatrix

Name:              PrMatrix
Syntax:	           @PrMatrix-syntax
Keywords:
Description:       This class implements a matrix
Member functions:

Constructors:
Files:
Example:

See also:
Developed by:      SINTEF Applied Mathematics, Oslo, Norway
Author:	           Michael Floater, SINTEF
Date:              Dec. 98
*/

#endif // PRMATRIX_H
