//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef PRMAT_H
#define PRMAT_H

#include <vector>
#ifndef __BORLANDC__
class ostream;
#endif

#include "GoTools/parametrization/PrMatrix.h"

/*<PrMat-syntax: */

/// This class implements a matrix
class PrMat : public PrMatrix
{
protected:
  // elements stored column-wise
  std::vector<double> a_;
  int m_,n_;

public:
  /** @name Derived from base class */
  //@{
  virtual int rows() const {return m_;}
  virtual int colmns() const {return n_;}
  virtual double operator () (int i, int j) const;
  /// Find y = Ax
  virtual void prod(const PrVec& x, PrVec& y) const;
  virtual void read(std::istream& is);

  virtual ~PrMat();
  //@}

  /** @name Other functions */
  //@{
  /// Constructor
  /// \param m number of columns
  /// \param n number of rows
  PrMat(int m, int n, double val = 0.0);
  /// Empty default constructor
  PrMat() {}
  /// access element (i, j)
  double& operator () (int i, int j);
  /// change size of matrix
  void redim(int m, int n);
  //@}
};

/*>PrMat-syntax: */

//-----------------------------------------------------------------------------
inline double& PrMat::operator () (int i, int j)
//-----------------------------------------------------------------------------
{
  return a_[i*n_+j];
}

/*Class:PrMat

Name:              PrMat
Syntax:	           @PrMat-syntax
Keywords:
Description:
Member functions:

Constructors:
Files:
Example:

See also:
Developed by:      SINTEF Applied Mathematics, Oslo, Norway
Author:	           Michael Floater, SINTEF
Date:              Dec. 98
*/

#endif // PRMAT_H
