//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/lrsplines2D/LRBenchmarkUtils.h"
#include "GoTools/utils/timeutils.h"
#include <omp.h>


using std::vector;


namespace Go
{

double benchmarkSfRefinement(LRSplineSurface& lr_sf,
			     const vector<LRSplineSurface::Refinement2D>& refs,
			     bool single_insertions)
{
    // double time0 = omp_get_wtime();
    double time0 = getCurrentTime();

    if (single_insertions)
    { // On refinement at the time.
	for (size_t ki = 0; ki < refs.size(); ++ki)
	{
#if 0//ndef NDEBUG
	    std::cout << "DEBUG: ref num: ki = " << ki << std::endl;
#endif
	    lr_sf.refine(refs[ki]);
	}
    }
    else
    {
	lr_sf.refine(refs);
    }

    // double time1 = omp_get_wtime(); // Measured in seconds.
    double time1 = getCurrentTime();
    double time_spent = time1 - time0;

    return time_spent;
}

}
