//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/isogeometric_model/EvalFunctorCurve.h"

namespace Go
{

  //===========================================================================
  EvalFunctorCurve::EvalFunctorCurve(BdCondFunctor* fbd, shared_ptr<SplineCurve> geo_curve, int dimension):
    functor_(fbd),
    geo_curve_(geo_curve),
    dim_(dimension)
  //===========================================================================
  {
  }


  //===========================================================================
  EvalFunctorCurve::~EvalFunctorCurve()
  //===========================================================================
  {
  }


  //===========================================================================
  Point EvalFunctorCurve::eval( double t) const
  //===========================================================================
  {
    Point geo_pt;
    geo_curve_->point(geo_pt, t);
    return functor_->evaluate(geo_pt);
  }


  //===========================================================================
  void EvalFunctorCurve::eval( double t, int n, Point der[]) const
  //===========================================================================
  {
    if (n >= 0)
      der[0] = eval(t);
    if (n >= 1)
      {
	double delta_default = 0.01;
	double delta;
	double start_par = start();
	double end_par = end();
	if (t + delta_default <= end_par)
	  delta = delta_default;
	else if (t - delta_default >= start_par)
	  delta = -delta_default;
	else if (end_par - t >= t - start_par)
	  delta = end_par - t;
	else
	  delta = start_par - t;
	der[1] = (1.0 / delta) * (eval(t + delta) - der[0]);
      }
    if (n >= 2)
      {
	Point zero(dim());
	for (int i = 0; i < dim(); ++i)
	  zero[i] = 0.0;
	for (int i = 2; i <= n; ++i)
	  der[i] = zero;
      }
  }


  //===========================================================================
  double EvalFunctorCurve::start() const
  //===========================================================================
  {
    return geo_curve_->startparam();
  }


  //===========================================================================
  double EvalFunctorCurve::end() const
  //===========================================================================
  {
    return geo_curve_->endparam();
  }


  //===========================================================================
  int EvalFunctorCurve::dim() const
  //===========================================================================
  {
    return dim_;
  }


  //===========================================================================
  bool EvalFunctorCurve::approximationOK(double par, Point approxpos,
					 double tol1, double tol2) const
  //===========================================================================
  {
    return true;
  }


} // namespace Go
