//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

// #include "GoTools/isogeometric_model/SfSolution.h"
#include "GoTools/isogeometric_model/BlockSolution.h"


namespace Go
{

  //===========================================================================
  BlockSolution::~BlockSolution()
  //===========================================================================
  {
  }


  //===========================================================================
  SfSolution* BlockSolution::asSfSolution()
  //===========================================================================
  {
    return NULL;
  }


  //===========================================================================
  VolSolution* BlockSolution::asVolSolution()
  //===========================================================================
  {
    return NULL;
  }


  //===========================================================================
  int BlockSolution::nmbCoefs(int pardir) const
  //===========================================================================
  {
    return basis(pardir).numCoefs();
  }


  //===========================================================================
  int BlockSolution::degree(int pardir) const
  //===========================================================================
  {
    return basis(pardir).order() - 1;
  }


  //===========================================================================
  vector<double> BlockSolution::knots(int pardir) const
  //===========================================================================
  {
    BsplineBasis bas = basis(pardir);
    vector<double> result(bas.order() + bas.numCoefs());
    vector<double>::const_iterator
      coef_begin = bas.begin(),
      coef_end = bas.end();
    copy(coef_begin, coef_end, result.begin());
    return result;
  }


  //===========================================================================
  vector<double> BlockSolution::distinctKnots(int pardir) const
  //===========================================================================
  {
    vector<double> result;
    basis(pardir).knotsSimple(result);
    return result;
  }


} // end namespace Go
