//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef __ISOGEOMETRICMODEL_H
#define __ISOGEOMETRICMODEL_H


#include "GoTools/topology/tpTopologyTable.h"



namespace Go
{

  class IsogeometricModel
  {
  public:
    // Constructor
    IsogeometricModel(tpTolerances toptol)
      : toptol_(toptol)
    {
    }


    // Destructor
    virtual ~IsogeometricModel();

    virtual int getNmbOfBoundaries() const = 0;

    // Ensure minimum degree of solution space
    virtual void setMinimumDegree(int degree, int solutionspace_idx) = 0;

    // Update spline spaces of the solution to ensure consistence
    virtual void updateSolutionSplineSpace() = 0;

    // Get tolerances
    virtual tpTolerances getTolerances() const
    { return toptol_; }

    // Set tolerances
    virtual void setTolerances(tpTolerances t)
    { toptol_ = t; }

  private:

    tpTolerances toptol_;

  };   // end class IsogeometricModel

} // end namespace Go


#endif    // #ifndef __ISOGEOMETRICMODEL_H
