//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef __BLOCKPOINTBDCOND_H
#define __BLOCKPOINTBDCOND_H


#include <vector>
#include "GoTools/utils/Point.h"

namespace Go
{

  // Abstract top class for a pointwise boundary condition of Dirichlet type
  class BlockPointBdCond
  {
  public:
    // Constructor
    BlockPointBdCond();

    // Destructor
    virtual ~BlockPointBdCond();

    // Get the index of the associated solution space
    virtual int getSolutionSpaceIdx() const;

    // Get the enumeration of affected surface coefficients (in the solution space)
    // NB! The number of a surface coefficient is not equal to the number of the degrees 
    // of freedom as a coefficient may have several components!
    virtual void 
      getCoefficientsEnumeration(std::vector<int>& local_enumeration) const = 0;

    // Get the value of the condition
    virtual Point getConditionValue() const = 0;

    // Get enumeration of affected surface coefficients and the factors in the
    // equation for requiring the current boundary to interpolate the condition
    virtual void 
      getInterpolationFactors(std::vector<std::pair<int,double> >& factors) const = 0;

  protected:

  };   // end class BlockPointBdCond
 
} // end namespace Go


#endif    // #ifndef __BLOCKPOINTBDCOND_H
