//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/intersections/PtPtIntersector.h"
#include "GoTools/intersections/IntersectionPool.h"
#include "GoTools/intersections/IntersectionPoint.h"



namespace Go {


//===========================================================================
PtPtIntersector::PtPtIntersector(shared_ptr<ParamGeomInt> point1, 
				 shared_ptr<ParamGeomInt> point2,
				 shared_ptr<GeoTol> epsge, 
				 Intersector *prev,
				 int eliminated_parameter,
				 double eliminated_value)
  : Intersector2Obj(point1, point2, epsge, prev, eliminated_parameter, eliminated_value)
//===========================================================================
{
  
}

//===========================================================================
PtPtIntersector::PtPtIntersector(shared_ptr<ParamGeomInt> point1, 
				 shared_ptr<ParamGeomInt> point2,
				 double epsge,  
				 Intersector *prev,
				 int eliminated_parameter,
				 double eliminated_value)
  : Intersector2Obj(point1, point2, epsge, prev, eliminated_parameter, eliminated_value)
//===========================================================================
{
  
}

//===========================================================================
PtPtIntersector::~PtPtIntersector()
//===========================================================================
{
  // Currently empty
}

//===========================================================================
shared_ptr<Intersector> 
PtPtIntersector::lowerOrderIntersector(shared_ptr<ParamGeomInt> obj1,
				       shared_ptr<ParamGeomInt> obj2, 
				       Intersector* prev,
				       int eliminated_parameter,
				       double eliminated_value)
//===========================================================================
{
  // No lower order intersector exist!
  // It does not make sense to return anything.
  // We should never enter this routine
  shared_ptr<PtPtIntersector> curr_inter; 

  return curr_inter;
}

//===========================================================================
int PtPtIntersector::checkCoincidence()
//===========================================================================
{
  // Coincidence between two points

  return 0;
}

//===========================================================================
void PtPtIntersector::microCase()
//===========================================================================
{
    // At most one intersection points is expected. Check if there exist
    // one already
    int nmb_pt = int_results_->numIntersectionPoints();
    if (nmb_pt > 0)
	return;  // Nothing more to do

  // Check for an intersection between the two points. First
  // fetch the point instances
  Point pt1, pt2;
  double tpar = 0.0;
  obj_int_[0]->point(pt1, &tpar);  // The parameter value is not relevant 
                               // in this case
  obj_int_[1]->point(pt2, &tpar);
  if (pt1.dist(pt2) <= epsge_->getEpsge())
    {
      int_results_->addIntersectionPoint(obj_int_[0], obj_int_[1], getTolerance(), 0, 0);
    }
}

//===========================================================================
int PtPtIntersector::updateIntersections()
//===========================================================================
{
  // Interation does not make sense
  return 0;
}

//===========================================================================
//
// Purpose : Given points.
//
// Written by : Vibeke Skytt, 1204
//
//===========================================================================
int PtPtIntersector::linearCase()
//===========================================================================
{
  return 0;
}

//===========================================================================
int PtPtIntersector::doSubdivide()
//===========================================================================
{
  // Subdivision does not make sense in this case
  return 0;
}

} // namespace Go
