//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/intersections/ParamPointInt.h"
#include "GoTools/utils/CompositeBox.h"
#include "GoTools/utils/RotatedBox.h"
#include "GoTools/utils/DirectionCone.h"


using std::vector;


namespace Go {


//===========================================================================
ParamPointInt::ParamPointInt(shared_ptr<Point> point, ParamGeomInt* parent)
    : ParamGeomInt(parent), point_(point),
      coords_(point->begin(), point->end())
//===========================================================================
{
  dim_ = point_->dimension();
}


//===========================================================================
CompositeBox  ParamPointInt::compositeBox() const
//===========================================================================
{
  CompositeBox bbox(*(point_.get()), *(point_.get()));
  return bbox;
}


//===========================================================================
RotatedBox  ParamPointInt::getRotatedBox(std::vector<Point>& axis) const
//===========================================================================
{
    RotatedBox box(point_->begin(), dimension(), 1, 1, &axis[0]);
    return box;
}


//===========================================================================
DirectionCone ParamPointInt::directionCone() const
//===========================================================================
{
  Point centre(dim_);
  centre.setValue(0.0);
  DirectionCone cone(centre, 0.0);
  return cone;
}


//===========================================================================
void ParamPointInt::
getBoundaryObjects(vector<shared_ptr<BoundaryGeomInt> >& bd_objs)
//===========================================================================
{
  // A point has no boundaries
  return;
}


//===========================================================================


} // namespace Go
