//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/intersections/ParamGeomInt.h"
#include "GoTools/utils/DirectionCone.h"
#include "GoTools/utils/Point.h"
#include "GoTools/utils/CompositeBox.h"


namespace Go {


//===========================================================================
DirectionCone ParamGeomInt::reducedDirectionCone(bool reduce_at_bd[4],
						 double epsge) const
//===========================================================================
{
    // Default implementation
    return directionCone();
}


//===========================================================================
bool ParamGeomInt::isLinear(double epsge)
//===========================================================================
{
    // First make angular condition based on geometry size and tolerance
    CompositeBox box = compositeBox();
    Point low = box.low();
    Point high = box.high();

    int dim = low.dimension();
    double bsize = 0.0;
    for (int kj=0; kj<dim; kj++)
	bsize = std::max(bsize, high[kj]-low[kj]);

    double ang_tol = epsge/(2.0*bsize);
    DirectionCone cone;
    try {
	cone = directionCone();
    }
    catch (...)
    {
	return false;
    }

    if (cone.greaterThanPi() || cone.angle() >= ang_tol)
	return false;  // The current object is not linear
    else
	return true;
    
}

//===========================================================================
bool ParamGeomInt::coneLargerThanPi()
//===========================================================================
{
    DirectionCone cone;
    try {
	cone = directionCone();
    }
    catch (...)
    {
	return true;
    }

    if (cone.greaterThanPi())
	return true;

    return false;
}

//===========================================================================


} // namespace Go

