//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/intersections/IntersectionCurve.h"
#include <list>
#include <memory>

using std::list;
using std::ostream;


namespace Go {


//===========================================================================
shared_ptr<IntersectionPoint>
IntersectionCurve::getGuidePoint(int index) const 
//===========================================================================
{
    DEBUG_ERROR_IF(index < 0 || index >= int(ipoints_.size()),
	     "index out of range in IntersectionCurve::getGuidePoint()");

    list<shared_ptr<IntersectionPoint> >::const_iterator it
	= ipoints_.begin();
    for (int i = 0; i < index; ++i) {
	++it;
    }
    return *it;
} 


//===========================================================================
bool IntersectionCurve::
getGuidePointTangent(shared_ptr<IntersectionPoint> pt, 
		     Point& tan, 
		     int type) const
//===========================================================================
{
    list<shared_ptr<IntersectionPoint> >::const_iterator it;
    it = find(ipoints_.begin(), ipoints_.end(), pt);
    if (it != ipoints_.end()) {
	switch(type) {
	case 1:
	    tan = (*it)->getPar1Dir(); // bool second_branch = false ??
	    break;
	case 2:
	    tan = (*it)->getPar2Dir(); // bool second_branch = false ??
	    break;
	default:
	    tan = (*it)->getTangent();
	}
	return true;
    } 
    // could not find this point
    return false;
}

//===========================================================================
void IntersectionCurve::writeIPointsToStream(ostream& os) const
//===========================================================================
{
    size_t num_pts = ipoints_.size();
    os << num_pts << '\n';

    for (list<shared_ptr<IntersectionPoint> >::const_iterator it
	     = ipoints_.begin(); it != ipoints_.end(); ++it) {
	(*it)->write(os);
	os << '\n';
    }
}


//===========================================================================


}; // end namespace Go


