//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/intersections/GeoTol.h"
#include <iostream>

using namespace std;
namespace Go
{
//===========================================================================
GeoTol::GeoTol(double epsge, double rel_par_res, double numerical_tol)
    : epsge_(epsge), 
      eps_bracket_(0.1), 
      ang_tol_(0.01), 
      rel_par_res_(rel_par_res),
      numerical_tol_(numerical_tol)
//===========================================================================
  {
      if (epsge <= 10e-5)
	  ref_ang_ = 0.01;
      else if (epsge <= 10e-3)
	  ref_ang_ = 0.1;
      else
	  ref_ang_ = 0.5;
  }

//===========================================================================
GeoTol::GeoTol(GeoTol *epsge)
{
    epsge_ = epsge->epsge_;
    eps_bracket_ = epsge->eps_bracket_;
    ref_ang_ = epsge->ref_ang_;
    ang_tol_ = epsge->ang_tol_;
    rel_par_res_ = epsge->rel_par_res_;
    numerical_tol_ = epsge->numerical_tol_;
}

//===========================================================================
  GeoTol::~GeoTol()
//===========================================================================
{
}

//===========================================================================
void GeoTol::write(ostream& os) const
//===========================================================================
{
    os << epsge_ << ' ';
    os << eps_bracket_ << ' ';
    os << ref_ang_ << ' ';
    os << ang_tol_ << ' ';

    os << rel_par_res_ << ' ';
    os << numerical_tol_ << ' ';
}

//===========================================================================
void GeoTol::read(istream& is)
//===========================================================================
{
    is >> epsge_;
    is >> eps_bracket_;
    is >> ref_ang_;
    is >> ang_tol_;
    is >> rel_par_res_;
    is >> numerical_tol_;
}

};
