//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/intersections/IntersectionCurve.h"
#include "GoTools/geometry/SplineCurve.h"
#include <stdexcept>


using std::logic_error;


namespace Go {


//===========================================================================
DegeneratedIntersectionCurve::~DegeneratedIntersectionCurve() {}
//===========================================================================


//===========================================================================
shared_ptr<ParamCurve> DegeneratedIntersectionCurve::getCurve() const 
//===========================================================================
{
    // Curve is assumed to be collapsed into a single point.  Creating 
    // degenerated spline curve.

    const int dim = 3; //@ can we always assume this?
    const double knot[] = {0, 0, 1, 1};
    double coef[dim * 2];
    const Point temp = ipoints_.front()->getPoint();
    ASSERT(temp.dimension() == dim);
    for (int i = 0; i < dim; ++i) {
	coef[i] = coef[i + dim] = temp[i];
    }

    MESSAGE("Converting a degenerated IntersectionCurve into a ParamCurve!");
    return shared_ptr<ParamCurve>(new SplineCurve(2, 2, knot, coef,
						  dim, false));
}


//===========================================================================
shared_ptr<ParamCurve>
DegeneratedIntersectionCurve::getParamCurve(int obj_nmb) const 
//===========================================================================
{
    shared_ptr<ParamCurve> result;
    switch (obj_nmb) {
    case 1:
	// implement this
	// result = something
	break;
    case 2:
	// implement this
	//result = something
	break;
    default:
	throw logic_error("Argument to getParamCurve() should be 1 or 2.");
    }
    if (result.get() == 0) {
	MESSAGE("Warning;  Returned isocurve is a zero pointer.\n"
		"It should have been precalculated, but this functionality\n"
		"is not yet implemented. ");
    }

    MESSAGE("Converting a degenerated IntersectionCurve into a ParamCurve!");
    return result;
}


//===========================================================================


}; // end namespace Go
