//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _SPHEREINT_H
#define _SPHEREINT_H


#include "GoTools/intersections/AlgObj3DInt.h"
#include "GoTools/utils/Point.h"


namespace Go {


class SplineSurface;


/// Class representing spherical algebraic intersection objects.

class SphereInt : public AlgObj3DInt {
public:
    /// Constructor.
    /// Used when reading from file.
    SphereInt();

    /// Constructor.
    /// \param center the center point of the sphere.
    /// \param radius the radius of the sphere.
    SphereInt(Point center, double radius);

    /// Destructor.
    virtual ~SphereInt();

    /// Read a sphere description from file.
    /// \param is the stream containing the sphere description.
    void read(std::istream& is);

    /// Get center point of the sphere.
    /// \return The center point of the sphere.
    Point center() const;

    /// Get the radius of the sphere.
    /// \return The radius of the sphere.
    double radius() const;

    /// Get a SplineSuface representing the sphere. This can be used to
    /// visualize the object.
    /// \return The spline surface of the sphere.
    SplineSurface* surface() const;

private:

    Point center_; // 3D ref point (x_0, y_0, z_0).
    double radius_; // (x-x0)^2 + (y-y0)^2 + (z-z0)^2 = radius_^2

};


} // namespace Go


#endif // _SPHEREINT_H

