//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _SINGULARITYTYPE_H
#define _SINGULARITYTYPE_H

namespace Go {
    /// A classification of an IntersectionPoint, based on the nature of the
    /// intersection on which it lies.
  enum SingularityType
      {
	  /// IntersectionPoint lies on normal, transversal intersection
	  ORDINARY_POINT = 0, 
	  /// The two intersecting objects are tangent to each other at the
	  /// location of this IntersectionPoint.
	  TANGENTIAL_POINT, 
	  /// This is an isolated IntersectionPoint (does not lie on an 
	  /// IntersectionCurve or on a partial coincidence area).
	  ISOLATED_POINT, 
          /// This is an IntersectionPoint where flere interection curves meet.
	  BRANCH_POINT,  
	  /// The two objects intersecting at this point have same tangent
	  /// plane AND curvature.
	  HIGHER_ORDER_POINT 
      };
};

#endif // _SINGULARITYTYPE_H
