//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _LINEINT_H
#define _LINEINT_H


#include "GoTools/intersections/AlgObj2DInt.h"
#include "GoTools/utils/Point.h"


namespace Go {


/// Class representing an algebraic line in 2-dimensional space.

class Line2DInt : public AlgObj2DInt {
public:
    /// Constructor.
    /// \param point reference point which lies on the line.
    /// \param dir direction of the line.
    Line2DInt(Point point, Point dir);

    /// Constructor.
    /// The line is given by the expression \f$ax + by + c = 0\f$.
    /// \param a the x multiplicator.
    /// \param b the y multiplicator.
    /// \param c the constant
    Line2DInt(double a, double b, double c);

    /// Destructor.
    virtual ~Line2DInt(){};

    /// Get the x multiplicator.
    /// \return The x multiplicator.
    double a();

    /// Get the y multiplicator.
    /// \return The y multiplicator.
    double b();

    /// Get the constant.
    /// \return The constant.
    double c();

private:

    Point point_; // 2D ref point.
    Point dir_; // 2D line dir.

    // Compute point_ & dir_ based on a, b & c (as given by factors_).
    void computePoints();

    // Compute a, b & c based on point_ & dir_.
    void computeConstants(Point point, Point dir,
			  double& a, double& b, double& c);

};


} // namespace Go


#endif // _LINEINT_H
