//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _IDENTITY_H
#define _IDENTITY_H

#include <memory>
#include "GoTools/utils/Point.h"
#include "GoTools/intersections/GeoTol.h"

#include <vector>

namespace Go 
{

    class ParamSurfaceInt;
    class ParamSurface;
    class ParamCurve;
    
    /// Check coincidence

    class Identity
	{
	public:
	    /// Return value = 0 : Not coincident
	    ///              = 1 : Coincident surfaces
	    ///              = 2 : Surface one is embedded in surface two
	    ///              = 3 : Surface two is embedded in surface one
	    int identicalSfs(shared_ptr<ParamSurface> sf1,
			     shared_ptr<ParamSurface> sf2,
			     double tol);

	    /// Return value = 0 : Not coincident
	    ///              = 1 : Coincident curves
	    ///              = 2 : Curve one is embedded in curve two
	    ///              = 3 : Curve two is embedded in curve one
	    int identicalCvs(shared_ptr<ParamCurve> cv1, double start1, double end1,
			     shared_ptr<ParamCurve> cv2, double start2, double end2,
			     double tol);
	private:
	    int internalCoincidence(shared_ptr<ParamSurfaceInt>& intsf1, 
				    shared_ptr<ParamSurfaceInt>& intsf2, 
				    shared_ptr<GeoTol>& eps);
	};

} // namespace Go

#endif // _IDENTITY_H

