//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _BOUNDARYFUNCTIONINT_H
#define _BOUNDARYFUNCTIONINT_H


#include "GoTools/utils/config.h"
#include <memory>


namespace Go {


class ParamFunctionInt;


/// This struct is a helper struct that bundles boundary information
/// for an object of type ParamFunctionInt.

struct BoundaryFunctionInt {

    shared_ptr<ParamFunctionInt> bd_obj_;
    int pardir_; // 2dim case: 0 || 1 (dir of par_, i.e. opp that of
		 // bd_obj_).
    double par_;

    /// Constructor
    /// \param bd_obj shared pointer to the object of interest
    /// \param dir parameter direction that specifies the boundary
    /// \param par the value of the relevant parameter at the boundary
    BoundaryFunctionInt(shared_ptr<ParamFunctionInt> bd_obj,
			int dir, double par)
    {
	bd_obj_ =  bd_obj;
	pardir_ = dir;
	par_ = par;
    }

    /// Get the parameter direction that specifies the boundary
    /// \return the parameter direction
    int getDir()
    { return pardir_; }

    /// Get the value of the relevant parameter at the boundary
    /// \return the parameter value
    double getPar()
    { return par_; }

    /// Get the object which the boundary belongs to
    /// \return shared pointer to the object
    shared_ptr<ParamFunctionInt> getObject()
    { return bd_obj_; }
};


} // namespace Go


#endif // _BOUNDARYFUNCTIONINT_H

