//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/implicitization/ImplicitizeSurfaceAlgo.h"
#include "GoTools/implicitization/ImplicitUtils.h"
#include "GoTools/geometry/GeometryTools.h"
#include "newmatio.h"
#include "newmat.h"


using namespace std;


namespace Go {


//==========================================================================
void ImplicitizeSurfaceAlgo::perform()
//==========================================================================
{
    // Create barycentric coordinate system
    create_bary_coord_system3D(surf_, bc_);

    // Convert spline curve to barycentric coordinates
    SplineSurface surf_bc;
    cart_to_bary(surf_, bc_, surf_bc);

    // Check if the surface has a single patch
    bool single_patch = (surf_.order_u() == surf_.numCoefs_u()
			 && surf_.order_v() == surf_.numCoefs_v());

    // Make the matrix of numerical coefficients (the D-matrix). Any
    // vector in the nullspace of this matrix will be a solution.
    vector<vector<double> > mat;
    if (single_patch) {
	make_matrix(surf_bc, deg_, mat);
    } else {
	// The matrices from all the patches are stacked on top of each
	// other
	vector<SplineSurface> patches;
	GeometryTools::splitSurfaceIntoPatches(surf_bc, patches);
	int num = (int)patches.size();
	make_matrix(patches[0], deg_, mat);
	vector<vector<double> > tmp;
	for (int i = 1; i < num; ++i) {
	    make_matrix(patches[i], deg_, tmp);
	    mat.insert(mat.end(), tmp.begin(), tmp.end());
	}
    }

    // Find the nullspace and construct the implicit function.
    vector<double> b;
    make_implicit_svd(mat, b, sigma_min_);

    // Set the coefficients
    implicit_ = BernsteinTetrahedralPoly(deg_, b);

    return;
}


//==========================================================================


} // namespace Go
