//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/implicitization/Binomial.h"


using namespace std;


namespace Go {


//===========================================================================
void Binomial::init(int n)
//===========================================================================
{
    pascals_triangle.resize(n+1);
    for (int nr = 0; nr < n+1; ++nr) {
	pascals_triangle[nr].resize(nr+1);
	pascals_triangle[nr][0] = 1.0;
	for (int j = 1; j < nr; ++j) {
	    pascals_triangle[nr][j]
		= pascals_triangle[nr-1][j-1]
		+ pascals_triangle[nr-1][j];
	}
	pascals_triangle[nr][nr] = 1.0;
    }

    return;
}


//===========================================================================
void Binomial::expand(int n)
//===========================================================================
{
    int old_size = (int)pascals_triangle.size();
    pascals_triangle.resize(n+1);

    for (int nr = old_size; nr < n+1; ++nr) {
	pascals_triangle[nr].resize(nr+1);
	pascals_triangle[nr][0] = 1.0;
	for (int j = 1; j < nr; ++j) {
	    pascals_triangle[nr][j]
		= pascals_triangle[nr-1][j-1]
		+ pascals_triangle[nr-1][j];
	}
	pascals_triangle[nr][nr] = 1.0;
    }

    return;
}


//===========================================================================


} // namespace Go
