//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _IMPLICITIZATION_DOXYMAIN_H
#define _IMPLICITIZATION_DOXYMAIN_H

/// \page implicitization GoTools Implicitization
///
/// Contains tools for implicitizing spline curves and surfaces. Also
/// contains various classes for Bernstein polynomials.
/// 
/// Historically, the underlying ideas for implicitzation and
/// approximate implicitization were developed by Tor Dokken at
/// SINTEF, ICT, in his Ph.D. thesis: <a
/// href="http://www.sintef.no/upload/IKT/9011/geometri/GAIA%20II/Ph_D_Dokken_1997.pdf">Aspects
/// of Intersection Algorithms and Approximation</a>, University of
/// Oslo, Norway, 1997.
///
/// The implementations in this library was done in connection with
/// the EU projects <a href="http://www.sintef.no/IST_GAIA">GAIA I and
/// II</a>.
///
/// This module depends on the newmat matrix library, which is freely
/// available from <a href="http://www.robertnz.net/">www.robertnz.net</a>.

#endif // _IMPLICITIZATION_DOXYMAIN_H
